import tkinter
from PIL import Image, ImageTk
import requests
import io


def toon_robot_afbeelding():
    ingevoerde_naam = invoerveld.get()
    response = requests.get("https://robohash.org/" + ingevoerde_naam + ".png")
    afbeelding_data = response.content
    afbeelding = Image.open(io.BytesIO(afbeelding_data))
    afbeelding.thumbnail((200, 200))
    afbeelding_tk = ImageTk.PhotoImage(afbeelding)

    afbeelding_label.config(image=afbeelding_tk)
    afbeelding_label.image = afbeelding_tk


app = tkinter.Tk()
app.title("Robohash Applicatie")
app.geometry("400x300")

naam_label = tkinter.Label(app, text="Voer een naam in:")
naam_label.pack(pady=10)

invoerveld = tkinter.Entry(app)
invoerveld.pack(pady=10)

afbeelding_label = tkinter.Label(app)
afbeelding_label.pack()

genereer_knop = tkinter.Button(app, text="Genereer Robohash", command=toon_robot_afbeelding)
genereer_knop.pack(pady=20)

app.mainloop()